package com.ejie.aa94a.model.config;

import java.io.Serializable;
import java.util.List;

import com.ejie.aa94a.model.calculo.Estiba;

public class Solucion implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String codigo;
	private Integer numBobinas;
	private List<String> condiciones;
	private String grafico;
	private TipoDistancia tipoDistancia;
	private List<Posicion> posiciones;
	private List<Estiba> estibas;

	/**
	 * 
	 */
	public Solucion() {
		super();
	}

	/**
	 * @param codigo
	 * @param numBobinas
	 * @param condiciones
	 * @param grafico
	 * @param tipoDistancia
	 * @param posiciones
	 * @param estibas
	 */
	public Solucion(String codigo, Integer numBobinas,
			List<String> condiciones, String grafico,
			TipoDistancia tipoDistancia, List<Posicion> posiciones,
			List<Estiba> estibas) {
		super();
		this.codigo = codigo;
		this.numBobinas = numBobinas;
		this.condiciones = condiciones;
		this.grafico = grafico;
		this.tipoDistancia = tipoDistancia;
		this.posiciones = posiciones;
		this.estibas = estibas;
	}

	/**
	 * @return the codigo
	 */
	public String getCodigo() {
		return codigo;
	}

	/**
	 * @param codigo
	 *            the codigo to set
	 */
	public void setCodigo(String codigo) {
		this.codigo = codigo;
	}

	/**
	 * @return the condiciones
	 */
	public List<String> getCondiciones() {
		return condiciones;
	}

	/**
	 * @param condiciones
	 *            the condiciones to set
	 */
	public void setCondiciones(List<String> condiciones) {
		this.condiciones = condiciones;
	}

	/**
	 * @return the grafico
	 */
	public String getGrafico() {
		return grafico;
	}

	/**
	 * @param grafico
	 *            the grafico to set
	 */
	public void setGrafico(String grafico) {
		this.grafico = grafico;
	}

	/**
	 * @return the tipoDistancia
	 */
	public TipoDistancia getTipoDistancia() {
		return tipoDistancia;
	}

	/**
	 * @param tipoDistancia
	 *            the tipoDistancia to set
	 */
	public void setTipoDistancia(TipoDistancia tipoDistancia) {
		this.tipoDistancia = tipoDistancia;
	}

	/**
	 * @return the posiciones
	 */
	public List<Posicion> getPosiciones() {
		return posiciones;
	}

	/**
	 * @param posiciones
	 *            the posiciones to set
	 */
	public void setPosiciones(List<Posicion> posiciones) {
		this.posiciones = posiciones;
	}

	/**
	 * @return the estibas
	 */
	public List<Estiba> getEstibas() {
		return estibas;
	}

	/**
	 * @param estibas
	 *            the estibas to set
	 */
	public void setEstibas(List<Estiba> estibas) {
		this.estibas = estibas;
	}

	/**
	 * @return the numBobinas
	 */
	public Integer getNumBobinas() {
		return numBobinas;
	}

	/**
	 * @param numBobinas
	 *            the numBobinas to set
	 */
	public void setNumBobinas(Integer numBobinas) {
		this.numBobinas = numBobinas;
	}

}
